//
//  OPXSMAAuth.h
//  ApplicationFrameworks
//
//  Created by Rick Fillion on 2016-08-15.
//
//

#import <Foundation/Foundation.h>
#import "OPXAuth.h"

FOUNDATION_EXPORT NSString * const OPXSMAAuthMethodHMAC256;// = @"auth-sma-hmac256";

// auth info dictionary keys
FOUNDATION_EXPORT NSString * const OPXSMAAuthInfoDictionarySecretKey;// = @"secret";
FOUNDATION_EXPORT NSString * const OPXSMAAuthInfoDictionaryCSKey;// = @"cs";

@interface OPXSMAAuth : NSObject <OPXAuth>

@property (nonatomic, readonly, copy) NSString *challengeSecret;
@property (nonatomic, readonly, copy) NSString *secret;

- (NSString *)M3WithClientChallenge:(NSString *)clientChallenge;
- (NSString *)M4WithM3:(NSString *)M3;


// Exposed for sake of testing. Avoid using directly. 
- (instancetype)initWithMethod:(NSString *)method extId:(NSString *)extensionId challengeSecret:(NSString *)cs secret:(NSString *)secret alg:(NSString *)alg;

@end
